/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.itemcollectors;

import com.mojang.blaze3d.vertex.PoseStack;
import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.gui.BaseContainer;
import com.supermartijn642.core.gui.WidgetContainerScreen;
import com.supermartijn642.core.gui.WidgetScreen;
import com.supermartijn642.core.gui.widget.Widget;
import com.supermartijn642.core.registry.ClientRegistrationHandler;
import com.supermartijn642.core.render.RenderUtils;
import com.supermartijn642.itemcollectors.CollectorBlockEntity;
import com.supermartijn642.itemcollectors.CollectorBlockEntityRenderer;
import com.supermartijn642.itemcollectors.ItemCollectors;
import com.supermartijn642.itemcollectors.screen.AdvancedCollectorScreen;
import com.supermartijn642.itemcollectors.screen.BasicCollectorScreen;
import java.util.Random;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.DrawSelectionEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

public class ItemCollectorsClient {
    public static void register() {
        ClientRegistrationHandler handler = ClientRegistrationHandler.get((String)"itemcollectors");
        handler.registerContainerScreen(() -> ItemCollectors.filter_collector_container, container -> WidgetContainerScreen.of((Widget)new AdvancedCollectorScreen(container.level, container.getCollectorPosition()), (BaseContainer)container, (boolean)false));
        handler.registerCustomBlockEntityRenderer(() -> ItemCollectors.basic_collector_tile, CollectorBlockEntityRenderer::new);
        handler.registerCustomBlockEntityRenderer(() -> ItemCollectors.advanced_collector_tile, CollectorBlockEntityRenderer::new);
    }

    public static void openBasicCollectorScreen(Level level, BlockPos pos) {
        ClientUtils.displayScreen((Screen)WidgetScreen.of((Widget)new BasicCollectorScreen(level, pos)));
    }

    @Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class Events {
        @SubscribeEvent
        public static void onBlockHighlight(DrawSelectionEvent.HighlightBlock e) {
            Level level = ClientUtils.getWorld();
            BlockEntity entity = level.m_7702_(e.getTarget().m_82425_());
            if (entity instanceof CollectorBlockEntity) {
                e.getPoseStack().m_85836_();
                Vec3 camera = RenderUtils.getCameraPosition();
                e.getPoseStack().m_85837_(-camera.f_82479_, -camera.f_82480_, -camera.f_82481_);
                AABB area = ((CollectorBlockEntity)entity).getAffectedArea().m_82400_((double)0.05f);
                Random random = new Random(entity.m_58899_().hashCode());
                float red = random.nextFloat();
                float green = random.nextFloat();
                float blue = random.nextFloat();
                float alpha = 0.3f;
                RenderUtils.renderBox((PoseStack)e.getPoseStack(), (AABB)area, (float)red, (float)green, (float)blue, (boolean)true);
                RenderUtils.renderBoxSides((PoseStack)e.getPoseStack(), (AABB)area, (float)red, (float)green, (float)blue, (float)alpha, (boolean)true);
                e.getPoseStack().m_85849_();
            }
        }
    }
}

